#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<int> X(n), H(n);
    for(int &v : X) cin >> v;
    for(int &v : H) cin >> v;

    vector<array<int,3>> a(n); 
    for(int i=0;i<n;i++)
        a[i] = {X[i], H[i], i};

    sort(a.begin(), a.end());

    vector<pair<int,int>> pn(n-1);
    for(int i=0;i<n-1;i++){
        int x1=a[i][0], h1=a[i][1];
        int x2=a[i+1][0], h2=a[i+1][1];

        int xp=(h1 - h2 + x1 + x2)/2;
        int yp=h2 - (x2 - xp);
        pn[i]={xp, yp};
    }

    vector<int> L(n,-1), R(n,-1);
    stack<int> st;
    for(int i=0;i<n;i++){
        while(!st.empty() && a[st.top()][1] < a[i][1]) st.pop();
        if(!st.empty()) L[i] = st.top();
        st.push(i);
    }
    while(!st.empty()) st.pop();
    for(int i=n-1;i>=0;i--){
        while(!st.empty() && a[st.top()][1] < a[i][1]) st.pop();
        if(!st.empty()) R[i] = st.top();
        st.push(i);
    }

    vector<int> ans(n);

    for(int i=0;i<n;i++){
        int best = INT_MAX;
        int ind = L[i];
        if(ind != -1){
            if(a[ind][1] == a[i][1]){
                best = abs(a[i][0] - a[ind][0]);
            } else {
                auto [xp,yp] = pn[ind];
                xp -= (a[i][1] - yp);
                best = abs(a[i][0] - xp);
            }
        }
        ind = R[i];
        if(ind != -1){
            if(a[ind][1] == a[i][1]){
                best = min(best, abs(a[i][0] - a[ind][0]));
            } else {
                auto [xp,yp] = pn[ind-1];
                xp += (a[i][1] - yp);
                best = min(best, abs(a[i][0] - xp));
            }
        }

        int orig = a[i][2];
        ans[orig] = (best==INT_MAX ? -1 : best);
    }
    for(int i=0;i<n;i++)
        cout << ans[i] << "\n";
}